/* FileGranulate Demo
 Uses GranulateRandom UGen To granulate a sound file.
 The GranulateRandom UGen is basically an amplitude modulation of the
 incoming audio, which turns on for a random amount of time and then off,
 again for a random amount of time.  If one uses several of these
 concurrently, it produces the "grain cloud" typical of granular synthesis.
 
 For more information about Minim and additional features, 
 visit http://code.compartmental.net/minim/
 
 author: Anderson Mills<br/>
 Anderson Mills's work was supported by numediart (www.numediart.org)
 
 Modified by Al Biles to get the sound source from a sound file,
 add an ADSR envelope and a random pan, and add a reverse function to
 sometimes play the sound file backward before granulating it.
 Al Biles's work is supported by the good wishes of others.
 */

// Import everything necessary to make sound.
import ddf.minim.*;
import ddf.minim.ugens.*;

// Create all of the variables that will need to be accessed in
// more than one methods (setup(), draw(), stop()).
Minim minim;
AudioOutput out;

// Setup is run once at the beginning
void setup()
{
  // Initialize the drawing window
  size(512, 200);
  // Display file choices in console window
  println("h: Home on the Range, c: Clank, t: Default, d: Dean Scream");

  // Initialize the minim and out objects
  minim = new Minim(this);
  out = minim.getLineOut(Minim.STEREO, 1024);
}

// Draw is run many times
void draw()
{
  // Erase the window to dark green
  background( 0, 64, 32 );
  // Draw using a purple stroke
  stroke( 232, 0, 255 );
  // Draw the waveforms
  for ( int i = 0; i < out.bufferSize () - 1; i++ )
  {
    // Find the x position of each buffer value
    float x1  =  map( i, 0, out.bufferSize(), 0, width );
    float x2  =  map( i+1, 0, out.bufferSize(), 0, width );
    // Draw a line from one buffer position to the next for both channels
    line( x1, 50 + out.left.get(i)*50, x2, 50 + out.left.get(i+1)*50);
    line( x1, 150 + out.right.get(i)*50, x2, 150 + out.right.get(i+1)*50);
  }
}

void keyPressed()
{
  //'t' triggers a new, independent granulated play of the sound file
  if (key == 'h')
    out.playNote(0.1, 15.0, new GranFileInstrument("Home.wav", 0.4));
  else if (key == 'c')
    out.playNote(0.1, 15.0, new GranFileInstrument("ClankSourceMono.wav", 0.9));
  else if (key == 't')
    out.playNote(0.1, 4.0, new GranFileInstrument("Sound.wav", 0.8));
  else if (key == 'd')
    out.playNote(0.1, 3.0, new GranFileInstrument("DeanScream.wav", 0.8));
}